// 等待DOM加载完成
document.addEventListener('DOMContentLoaded', function() {
    // Banner轮播功能
    const bannerSlides = document.querySelectorAll('.banner-slide');
    const bannerIndicators = document.querySelectorAll('.indicator');
    const prevBtn = document.querySelector('.banner-btn.prev');
    const nextBtn = document.querySelector('.banner-btn.next');
    let currentSlide = 0;
    let slideInterval;

    // 初始化轮播
    if (bannerSlides.length > 0) {
        startSlideInterval();
        
        // 上一张按钮
        if (prevBtn) {
            prevBtn.addEventListener('click', function() {
                clearInterval(slideInterval);
                currentSlide = (currentSlide - 1 + bannerSlides.length) % bannerSlides.length;
                updateSlide();
                startSlideInterval();
            });
        }
        
        // 下一张按钮
        if (nextBtn) {
            nextBtn.addEventListener('click', function() {
                clearInterval(slideInterval);
                currentSlide = (currentSlide + 1) % bannerSlides.length;
                updateSlide();
                startSlideInterval();
            });
        }
        
        // 指示器点击
        bannerIndicators.forEach((indicator, index) => {
            indicator.addEventListener('click', function() {
                clearInterval(slideInterval);
                currentSlide = index;
                updateSlide();
                startSlideInterval();
            });
        });
    }

    // 更新轮播显示
    function updateSlide() {
        bannerSlides.forEach((slide, index) => {
            slide.classList.toggle('active', index === currentSlide);
        });
        
        bannerIndicators.forEach((indicator, index) => {
            indicator.classList.toggle('active', index === currentSlide);
        });
    }

    // 开始轮播定时器
    function startSlideInterval() {
        slideInterval = setInterval(() => {
            currentSlide = (currentSlide + 1) % bannerSlides.length;
            updateSlide();
        }, 5000);
    }

    // 播放页功能
    if (window.location.pathname.includes('play.html')) {
        // 播放按钮功能
        const playButton = document.getElementById('playButton');
        const playerPlaceholder = document.querySelector('.player-placeholder');
        const videoPlayer = document.getElementById('videoPlayer');
        
        if (playButton && playerPlaceholder && videoPlayer) {
            playButton.addEventListener('click', function() {
                playerPlaceholder.style.display = 'none';
                videoPlayer.style.display = 'block';
                
                // 模拟加载视频
                const video = videoPlayer.querySelector('video');
                if (video) {
                    // 实际项目中这里会设置真实的视频源
                    video.src = '#';
                    video.load();
                    video.play().catch(error => {
                        console.log('自动播放失败:', error);
                        // 自动播放失败时，提示用户手动播放
                        alert('由于浏览器限制，视频需要手动播放');
                    });
                }
            });
        }
        
        // 播放源切换
        const sourceButtons = document.querySelectorAll('.source-btn');
        sourceButtons.forEach(btn => {
            btn.addEventListener('click', function() {
                // 移除所有按钮的active类
                sourceButtons.forEach(b => b.classList.remove('active'));
                // 给当前点击的按钮添加active类
                this.classList.add('active');
                
                // 获取选中的播放源
                const source = this.getAttribute('data-source');
                
                // 模拟切换播放源
                if (videoPlayer.style.display === 'block') {
                    const video = videoPlayer.querySelector('video');
                    if (video) {
                        // 显示加载状态
                        videoPlayer.innerHTML = '<div class="loading">切换到播放源 ' + source + ' 中...</div>';
                        
                        // 模拟加载延迟
                        setTimeout(() => {
                            videoPlayer.innerHTML = `
                                <video controls width="100%" height="auto" poster="https://picsum.photos/1200/675?random=30">
                                    <source src="#" type="video/mp4">
                                    您的浏览器不支持HTML5视频播放。
                                </video>
                            `;
                            const newVideo = videoPlayer.querySelector('video');
                            newVideo.play().catch(error => {
                                console.log('播放失败:', error);
                            });
                        }, 1000);
                    }
                } else {
                    // 如果视频未播放，则只是切换源标记，不实际加载
                    console.log('已选择播放源 ' + source + '，点击播放按钮开始播放');
                }
            });
        });
    }
});
